#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BloodUnitStatus : BaseTest 
	{
		
		private DataTable _dtBloodUnitStatus;
		private BOL.BloodUnitStatus _tstBUS;
		private System.Guid _unitGuid;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				DataTable dtTemp = null;
				//
				try
				{
					dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND UnitStatusCode NOT IN ('D','M','T','X')", true);
				}
				catch(BOL.BusinessObjectException)
				{
					DataCreator.CreateIssuedBloodUnit(false);
					dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND UnitStatusCode NOT IN ('D','M','T','X')", true);
				}
				//
				if (dtTemp == null || dtTemp.Rows == null || dtTemp.Rows.Count == 0)
				{
					DataCreator.CreateIssuedBloodUnit(false);
					dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND UnitStatusCode NOT IN ('D','M','T','X')", true);
				}
				//
				this._unitGuid = (System.Guid)dtTemp.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid];

				this._dtBloodUnitStatus = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitStatus BUS JOIN BloodUnitStatusCodeCurrent BUSCC ON BUS.BloodUnitGuid = BUSCC.BloodUnitGuid WHERE UnitStatusCode NOT IN ('D','M','T','X') AND BUSCC.BloodUnitGuid = '" + this._unitGuid.ToString() + "'", true);

				this.RefreshData = false;
			}
			
			this._tstBUS = new BOL.BloodUnitStatus(this._unitGuid);
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			BOL.BloodUnitStatus tmpBUS = new BOL.BloodUnitStatus(this._unitGuid);
			
			Assert.IsNotNull(tmpBUS,"Object");
			Assert.AreEqual(this._unitGuid, tmpBUS.BloodUnitGuid, "BloodUnitGuid");
		}

		[Test]
		public void Ctor_Guid_Fail()
		{
			System.Guid unitGuid = System.Guid.NewGuid();

			BOL.BloodUnitStatus tmpBUS = new BOL.BloodUnitStatus(unitGuid);
			
			Assert.IsNotNull(tmpBUS,"Object");
			Assert.AreEqual(unitGuid, tmpBUS.BloodUnitGuid, "BloodUnitGuid");
			Assert.AreEqual(true, tmpBUS.IsNew, "IsNew");
		}

		[Test]
		public void IsFinal_Pass()
		{
			string statusCodeCurrent = UnitTestUtil.RunSQLGetDataRowDontThrowExceptionIfNoRowIsReturned(string.Concat("SELECT UnitStatusCode FROM BloodUnitStatusCodeCurrent WHERE BloodUnitGuid = '", _unitGuid, "'"))["UnitStatusCode"].ToString();

			UnitTestUtil.RunSQL(string.Concat("UPDATE BloodUnitStatusCodeCurrent SET UnitStatusCode = 'T' WHERE BloodUnitGuid = '", _unitGuid, "'"));

			DataTable dtFinal = UnitTestUtil.RunSQLGetDataTable(string.Concat("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodUnitGuid = '", _unitGuid, "'"));

			BOL.BloodUnitStatus tstBUS = new BOL.BloodUnitStatus((System.Guid)dtFinal.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid]);

			Assert.AreEqual(true, tstBUS.IsFinal(), "Discard Status");

			//Re-set status code
			UnitTestUtil.RunSQL(string.Concat("UPDATE BloodUnitStatusCodeCurrent SET UnitStatusCode = '", statusCodeCurrent, "' WHERE BloodUnitGuid = '", _unitGuid, "'"));
		}

		[Test]
		public void IsFinal_Fail()
		{
			DataTable dtFinal = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE UnitStatusCode = 'A'");

			BOL.BloodUnitStatus tstBUS = new BOL.BloodUnitStatus((System.Guid)dtFinal.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid]);

			Assert.AreEqual(false, tstBUS.IsFinal(), "Available Status");
		}

		[Test]
		public void GetPreviousBloodUnitStatusByGuid_Pass()
		{
			DataTable dtTest = BOL.BloodUnitStatus.GetPreviousBloodUnitStatusByGuid(this._tstBUS.BloodUnitGuid);
			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(true,"L,A,S,C,I,T,D,M,X".IndexOf(dtTest.Rows[0][0].ToString())>-1,"PreviousStatus");
		}

		[Test]
		public void GetPreviousBloodUnitStatusByGuid_Fail()
		{
			DataTable dtTest = BOL.BloodUnitStatus.GetPreviousBloodUnitStatusByGuid(System.Guid.NewGuid());
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void BloodUnitStatusGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			this._tstBUS.BloodUnitStatusGuid = tstValue;

			Assert.AreEqual(tstValue, this._tstBUS.BloodUnitStatusGuid, "BloodUnitStatusGuid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitStatusGuid_Fail()
		{
		}

		[Test]
		public void BloodUnitGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			this._tstBUS.BloodUnitGuid = tstValue;

			Assert.AreEqual(tstValue, this._tstBUS.BloodUnitGuid, "BloodUnitGuid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitGuid_Fail()
		{
		}

		[Test]
		public void UnitStatusCode_Pass()
		{
			Common.UnitStatusCode tstValue = this._tstBUS.UnitStatusCode;

			Assert.AreEqual(tstValue, this._tstBUS.UnitStatusCode, "UnitStatusCode");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void UnitStatusCode_Fail()
		{
		}

		[Test]
		public void UnitStatusDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;
			this._tstBUS.UnitStatusDate = tstValue;

			Assert.AreEqual(tstValue, this._tstBUS.UnitStatusDate, "UnitStatusDate");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnitStatusDate_Fail()
		{
		}

		[Test]
		public void UnitStatusComment_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstBUS.UnitStatusComments = tstValue;

			Assert.AreEqual(tstValue, this._tstBUS.UnitStatusComments, "UnitStatusComments");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void UnitStatusComments_Fail()
		{
			this._tstBUS.UnitStatusComments = "".PadRight(256,'X');
		}

		[Test]
		public void DiscardDetailCode_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			this._tstBUS.DiscardCannedCommentGuid = tstValue;

			Assert.AreEqual(tstValue, this._tstBUS.DiscardCannedCommentGuid, "DiscardCannedCommentGuid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DiscardDetailCode_Fail()
		{
		}


		[Test]
		public void BiohazardousWarningIndicator_Pass()
		{
			bool tstValue = (!this._tstBUS.BiohazardousWarningIndicator);
			this._tstBUS.BiohazardousWarningIndicator = tstValue;

			Assert.AreEqual(tstValue, this._tstBUS.BiohazardousWarningIndicator,"BiohazardousWarningIndicator");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BiohazardousWarningIndicator_Fail()
		{
		}

		[Test]
		public void QuarantineIndicator_Pass()
		{
			bool tstValue = (!this._tstBUS.QuarantineIndicator);
			this._tstBUS.QuarantineIndicator = tstValue;

			Assert.AreEqual(tstValue, this._tstBUS.QuarantineIndicator, "QuarantineIndicator");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void QuarantineIndicator_Fail()
		{
		}


		[Test]
		public void QuarantineDetailCode_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			this._tstBUS.QuarantineCannedCommentGuid = tstValue;

			Assert.AreEqual(tstValue, this._tstBUS.QuarantineCannedCommentGuid, "QuarantineCannedCommentGuid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void QuarantineDetailCode_Fail()
		{
		}


		[Test]
		public void LastUpdateDate_Pass()
		{
			System.DateTime tstValue = this._tstBUS.LastUpdateDate;

			Assert.AreEqual(tstValue, this._tstBUS.LastUpdateDate, "LastUpdateDate");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LastUpdateDate_Fail()
		{
		}

		[Test]
		public void PresumedTransfusedIndicator_Pass()
		{
			bool tstValue = (!this._tstBUS.PresumedTransfusedIndicator);
			this._tstBUS.PresumedTransfusedIndicator = tstValue;

			Assert.AreEqual(tstValue, this._tstBUS.PresumedTransfusedIndicator, "PresumedTransfusedIndicator");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PresumedTransfusedIndicator_Fail()
		{
		}

		[Test]
		public void RowVersion_Pass()
		{
			byte[] tstValue = this._tstBUS.RowVersion;
			this._tstBUS.RowVersion = tstValue;

			Assert.AreEqual(tstValue, this._tstBUS.RowVersion, "RowVersion");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void RowVersion_Fail()
		{
			this._tstBUS.RowVersion = null;
		}

		[Test]
		public void UnitStatusText_Pass()
		{
			Assert.IsTrue(this._tstBUS.UnitStatusText.Length > 0, "UnitStatusText");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnitStatusText_Fail()
		{
		}

		[Test]
		public void UnitStatusDescriptiveText_Pass()
		{
			Assert.IsTrue(this._tstBUS.UnitStatusDescriptiveText.Length > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void UnitStatusDescriptiveText_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drData = this._tstBUS.LoadDataRowFromThis(this._dtBloodUnitStatus.NewRow());

			Assert.AreEqual(this._tstBUS.BloodUnitStatusGuid, (System.Guid)drData[TABLES.BloodUnitStatus.BloodUnitStatusGuid], "BloodUnitStatusGuid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

	}
}
#endif


